package gov.va.med.mhv.usermgmt.util;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.data.model.Activity;
import gov.va.med.mhv.usermgmt.data.repository.ActivityRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;

public class AuditorEbenefits extends HttpServlet {

	private static final long serialVersionUID = -4257804902682761876L;

	@Autowired
	private UserProfileRepository userProfileRepository;
	
	@Autowired
	private ActivityRepository activityRepository;

	public AuditorEbenefits() {
		super();
	}

	protected void doGet(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
		System.out.println("In doGet");
    }

    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
		Activity activity = new Activity();
		activity.setAction("Select link to eBenefits");
		activity.setActivityType("Visit my eBenefits Acct");
		activity.setCompletionTime(new Timestamp(new Date().getTime()));
		activity.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
		activity.setStatus(true);
		activity.setDetailValue("");
		System.out.println("In doPost");
		if(request.getUserPrincipal() != null) {
			UserProfile uProfile = userProfileRepository.findByUserName(request.getUserPrincipal().getName());
			activity.setUserProfileId(uProfile.getId());
			activityRepository.save(activity);
		}
	}
}